---
Note type: Reference
tags:
  - ZoteroReference
Reference type: "book"
Bib_ref: "Dryzek JS (2013) _The Politics of the Earth: Environmental Discourses_. Oxford University Press."
Title: "The Politics of the Earth: Environmental Discourses"
Authors: "John S. Dryzek"
Year: "2013-01-01T00:00:00+00:00"
Journal-publisher: ""
Read: Read
Related areas:
  - "[[Research]]"
Related projects: 
Related tasks: 
Related references: 
Related zettels: 
Related meeting notes: 
Related resources: 
Related people: 
aliases:
  - '"The Politics of the Earth: Environmental Discourses"'
Creation date: "2022-11-30T20:03:15+00:00"
---

# Item notes from Zotero

Open in Zotero: [Dryzek - The Politics of the Earth Environmental Discourse.pdf](zotero://select/library/items/DTXNJW4V)
### Context

### Aim

[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=30&annotation=Q4JF6GE3) “This inquiry rests on the contention that language matters, that the way we construct, interpret, discuss, and analyze environmental problems has all kinds of consequences. **My intent is to lay out the basic structure of the discourses that have dominated recent environmental politics, and present their history, conflicts, and transformations**.” ([Dryzek, 2013, p. 30](zotero://select/library/items/IERE36N2))

[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=40&annotation=XZLQWBHH) “To assess more fully the worth and impact of a discourse requires attention to its critics as well as its adherents. Sometimes, adherents of different discourses will ignore and dismiss rather than engage one another. Nevertheless, dispute does occur across the boundaries of different discourses. Frequently, this occurs between the environmental discourse in question and the older discourse of industrialism. Occasionally, debate is engaged between the problem-solving, limits, sustainability, and green radical discourses. **One goal of this book is to promote such interchange**.” ([Dryzek, 2013, p. 40](zotero://select/library/items/IERE36N2))

### RQ

### Thesis

### Methodology

### Theoretical approach

### Findings

### Contributions

### Striking points

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=35&annotation=GW5T34AP)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=20&annotation=4T2HYEDD)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=21&annotation=EUQLXJ9Q)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=43&annotation=IWAZMZKZ)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=63&annotation=P3Y3B6SH)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=90&annotation=85VHPEUN)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=118&annotation=RWVHB6XX)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=138&annotation=9YUZNC68)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=160&annotation=ADQS396H)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=177&annotation=5CFAVASS)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=201&annotation=PG3ADWJ6)

  
[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=221&annotation=NF5ECW5X)

### Further research suggested

### My ideas/responses

### Useful references

### Related zettels

## Chapter 1: Making Sense of Earth's Politics: A Discourse Approach

### **History of environmental concerns**

- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=22&annotation=Z4Y3KC7N) “The early concerns were with pollution, wilderness preservation, population growth, and depletion of natural resources.” ([Dryzek, 2013, p. 22](zotero://select/library/items/IERE36N2))
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=22&annotation=AJ65UPAR) “Over time, these concerns have been joined by worries about energy supply, biodiversity, species extinction, climate change and other disruptions of the Earth system, depletion of the ozone layer in the upper atmosphere, toxic wastes, the protection of whole ecosystems, environmental justice, food safety, and genetically modified organisms.” ([Dryzek, 2013, p. 22](zotero://select/library/items/IERE36N2))
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=27&annotation=QDT5L2DK) “In all these conflicts, the different sides interpret the issues at hand in very different ways, At any time, the way the issue is dealt with depends largely (though not completely) on the balance of competing discourses. In this book I intend making sense of the last fifty years or so of environmental concern by mapping these discourses.” ([Dryzek, 2013, p. 27](zotero://select/library/items/IERE36N2))
    
    - [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=25&annotation=N9GF7L5M) “Even if one believes in progress (as I do), it would be a mistake to think of the history of environmental affairs in these terms.” ([Dryzek, 2013, p. 25](zotero://select/library/items/IERE36N2))
    - “contests over meaning are ubiquitous, and the way we think about basic concepts concerning the environment can change dramatically over time” ([Dryzek, 2013, p. 25](zotero://select/library/items/IERE36N2))

### The [[complexity]] of environmental problems

- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=28&annotation=FALC4QEE) “**Complexity** refers to the number and variety of elements and interactions in the environment of a decision system.” ([Dryzek, 2013, p. 28](zotero://select/library/items/IERE36N2))
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=28&annotation=MRJRTD8L) “When human decision systems (be they individuals or collective bodies such as governments) confront environmental problems, they encounter two orders of complexity.” ([Dryzek, 2013, p. 28](zotero://select/library/items/IERE36N2))
    
    - [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=28&annotation=Z4N3WCMI) “**Ecosystems** are complex, and our knowledge of them is limited”
    - [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=28&annotation=BP89IEI3) “**Human social systems** are complex too, which is why there is so much work for the ever-growing number of social scientists who study them.”
    - [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=28&annotation=KT8RDJA5) “Environmental problems by definition are found at the intersection of ecosystems and human social systems, thus doubly complex.”
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=28&annotation=K4PZKAQZ) “The more complex a situation, the larger the number of plausible perspectives upon it-because the harder it is to prove any one of them wrong.” ([Dryzek, 2013, p. 28](zotero://select/library/items/IERE36N2))

### [[Discourse]] as a means of [[sensemaking]] in the context of [[complexity]]

- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=28&annotation=ARSSS2AT) “A **discourse** is a shared way of apprehending the world.” ([Dryzek, 2013, p. 28](zotero://select/library/items/IERE36N2))
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=28&annotation=BIUMK6KV) “Embedded in language, it enables those who subscribe to it to interpret bits of information and put them together into coherent stories or accounts. Discourses construct meanings and relationships, helping define common sense and legitimate knowledge. Each discourse rests on assumptions, judgments, and contentions that provide the basic terms for analysis, debates, agreements, and disagreements.” ([Dryzek, 2013, p. 28](zotero://select/library/items/IERE36N2))
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=29&annotation=EBEIMLFS) “discourses both enable and constrain communication.” ([Dryzek, 2013, p. 29](zotero://select/library/items/IERE36N2))
- “Discourses are bound up with political practices and power”
    
    - “Discourses can themselves embody power in the way they condition the perceptions and values of those subject to them, such that some interests are advanced, others suppressed, some people made more compliant and governable (Foucault, 1980).” ([Dryzek, 2013, p. 29](zotero://select/library/items/IERE36N2))
    - “Discourses are also intertwined with some material political realities” ([Dryzek, 2013, p. 29](zotero://select/library/items/IERE36N2)) - e.g. neoliberal borderlessness of capital
    

### **Classifying the main environmental discourses**

- “Environmental discourse begins in industrial society, and so has to be positioned in the context of the discourse of **industrialism**” ([Dryzek, 2013, p. 33](zotero://select/library/items/IERE36N2))
    
    - Industrialism characterized in terms of economic growth and technological progress
    - Industrialism has been pursued by capitalist, communist, socialist and fascist states
- Environmental discourses must depart from industrialism, but there is scope for difference in the extent of this departure
    
    - **Reformist**:
    - **Radical**:
- Environmental discourses can have quite different approaches to the prospect of socioeconomic change
    
    - **Prosaic**: takes the existing political economy as necessary
    - **Imaginitive**: views environmentalism as an opportunity to pursue an alternative political economy
    

**Environmental** **problem** **solving**

- **Reformist** and **prosaic**: [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=34&annotation=HSP6N5VT) “defined by taking the political-economic status quo as given but in need of adjustment to cope with environmental problems, especially via public policy.” ([Dryzek, 2013, p. 34](zotero://select/library/items/IERE36N2))
- Story: particular economic activities have unpleasant side-effects, which require piecemeal remedies.
- e.g. [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=34&annotation=F8LDEVSA) “administrative regulation” - command and control  
    or
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=34&annotation=RL5XMIJR) “market-type incentive mechanisms” - carbon markets, private governance
- “Within the overall discourse of environmental problem solving there may be substantial disagreement as to which of these forms is appropriate. So, for example, a debate between proponents of administrative regulation and market-type incentive mechanisms for pollution control has been under way since the 1970s, with market proponents gradually gaining ground.”

**Limits** **and** **survival**

- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=34&annotation=P84I2AHB) “unchecked economic expansion and population growth will eventually exceed the Earth's stock of natural resources and the capacity of its ecosystems to support human agricultural and industrial activity, or the ability of the Earth system to accommodate stress.” ([Dryzek, 2013, p. 34](zotero://select/library/items/IERE36N2))
- Story: “the need to curb ever-growing human demands on the life-support capacities of natural systems.”
- e.g. doughnut economics, planetary boundaries
- **“radical** because it seeks a wholesale redistribution of power within the industrial political economy, and a wholesale reorientation away from perpetual economic growth” ([Dryzek, 2013, p. 35](zotero://select/library/items/IERE36N2))
- **“prosaic** because it sees solutions in terms of the options set by industrialism, notably, greater control of existing systems by administrators, scientists and other responsible elites.” ([Dryzek, 2013, p. 35](zotero://select/library/items/IERE36N2))

**Sustainability**

- Defined by ideas of ecological modernization whereby economic growth and environmental protection are seen as essentially complementary
- “defined by **imaginative** attempts to dissolve the conflicts between environmentalism and economic values that energize the discourses of **problem solving** and **limits**” ([Dryzek, 2013, p. 35](zotero://select/library/items/IERE36N2))
- **Reformist** because it remains commited to industrialist socioeconomics in this pursuit of a win-win solution
- Has become a “nodal discourse” (Fairclough, 2006) “around which other discourses cluster” ([Dryzek, 2013, p. 35](zotero://select/library/items/IERE36N2))

**Green** **radicalism**

- “adherents reject the basic structure of industrial society and the way the environment is conceptualized therein {**radical**} in favor of a variety of quite different alternative interpretations of humans, their society, and their place in the world {**imaginitive**}.” ([Dryzek, 2013, p. 35](zotero://select/library/items/IERE36N2))

### The elements of discourse

[Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=36&annotation=DDSLWY7C) “Each **discourse** constructs stories from the following **elements**.” ([Dryzek, 2013, p. 36](zotero://select/library/items/IERE36N2))

- **[[Ontology]]** - [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=36&annotation=L8PJC2CV) “Basic entities recognized or constructed”
    
    - “Different discourses see different things in the world.” - _connect to [[sensemaking]], simplifying the complexity of the world_
    - e.g. [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=36&annotation=WT7B99AM) “Some discourses recognize the existence of ecosystems, others have no concept of natural systems at all, seeing nature only in terms of brute matter.” ([Dryzek, 2013, p. 36](zotero://select/library/items/IERE36N2))
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=37&annotation=4RMBE4EM) “Assumptions about natural **relationships**” ([Dryzek, 2013, p. 37](zotero://select/library/items/IERE36N2))
    
    - “All discourses embody notions of what is natural in the relationships between different entities”
    - e.g. competition vs. cooperation; hierarchies vs equalities
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=37&annotation=9QSPM8F5) “**Agents** and their motives” ([Dryzek, 2013, p. 37](zotero://select/library/items/IERE36N2))
    
    - e.g. human vs non-human actors
    - e.g. “enlightened elites, rational consumers, ignorant and shortsighted populations, virtuous ordinary citizens, a Gaia that may be tough and forgiving or fragile and punishing […].” ([Dryzek, 2013, p. 37](zotero://select/library/items/IERE36N2))
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=37&annotation=MCDUEJYR) “Key **metaphors** and other rhetorical devices” ([Dryzek, 2013, p. 37](zotero://select/library/items/IERE36N2))
    
    - [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=38&annotation=HQJDFF6M) “Metaphors are rhetorical devices, deployed to convince listeners or readers by putting a situation in a particular light.” ([Dryzek, 2013, p. 38](zotero://select/library/items/IERE36N2))
    - e.g. spaceship earth, tragedy of the commons, machines, organisms, war, goddess, intelligence

### **The political effects of discourse**

- “The impact of discourse can often be felt in the **policies** of governments or international organizations” (p20)
    
    - e.g. “the flurry of environmental legislation enacted in many industrialized countries around 1970 mostly reflected a discourse of administrative rationalism (a subcategory of problem solving).”
- “Beyond affecting institutions, discourses can become **embodied in institutions**. When this happens, discourses constitute the informal understandings that provide the context for social interaction, on a par with formal institutional rules. Or to put it slightly differently, discourses can constitute institutional software while formal rules constitute institutional hardware.”
- Discourses might not affect policies or institutions directly, but rather affect **civil society practices**
    
    - e.g. “green radicalism has helped some individuals and communities to distance themselves from both government and corporate capitalism in putative attempts to create an alternative political economy relying on self-sufficiency.”
- Discourses “can also be felt directly on society and culture without having to pass through formal institutions or public policies. Contemporary social movements often target **the way ordinary people think and behave**, and much of their success can be judged in these terms.”
    
    - e.g. environmentalism effecting individual-level lifestyle changes
    

### **Assessing the effects of discourses**

- Checklist for assessing the effects of discourse
    
    1. “Politics associated with the discourse”
    2. “Effect on policies of governments”
    3. “Effect on institutions”
    4. “Social and cultural impact”
    5. “Arguments of critics”
    6. “Flaws revealed by evidence and argument”
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=40&annotation=XZLQWBHH) “To assess more fully the worth and impact of a discourse requires attention to its critics as well as its adherents. Sometimes, adherents of different discourses will ignore and dismiss rather than engage one another. Nevertheless, dispute does occur across the boundaries of different discourses. Frequently, this occurs between the environmental discourse in question and the older discourse of industrialism. Occasionally, debate is engaged between the problem-solving, limits, sustainability, and green radical discourses. **One goal of this book is to promote such interchange**.” ([Dryzek, 2013, p. 40](zotero://select/library/items/IERE36N2))
- [Go to annotation](zotero://open-pdf/library/items/DTXNJW4V?page=40&annotation=42CXWRE8) “Attention to the arguments of critics will facilitate identification of flaws in the discourse. Such identification will also be helped by attention to experience of the practical implications of the discourse, in politics, policies, institutions, and beyond. The tools of [[discourse analysis]] which I have enumerated **enable further critical analysis of the promise and peril attached to each discourse** in its contribution to environmental debate, analysis, and action.” ([Dryzek, 2013, p. 40](zotero://select/library/items/IERE36N2))
- **Contra [[Foucauldians]], discourse isn’t everything - [[critical realist]] approach**
    
    - “Discourses are powerful, but they are not impenetrable (as Foucault and his readers have themselves demonstrated in their own exposé of the history of various discourses). Foucault and his followers also often portray discourses in **hegemonic** terms, **meaning that one single discourse is typically dominant in any time and place, conditioning not just agreement but also the terms of dispute**.” ([Dryzek, 2013, p. 41](zotero://select/library/items/IERE36N2))
    - “In contrast, I believe that the variety found in environmental discourses is important. The environmental arena reveals that the discourse of industrialism was indeed hegemonic, to the extent that “the environment” was hardly conceptualized prior to the 1960s. However, this hegemony eventually began to disintegrate, yielding the range of environmental discourses now observable. While in its totality environmentalism can be positioned as a challenge to industrialism, it does not constitute a unified counter discourse. Rather, environmentalism is composed of a variety of discourses, sometimes complementing one another, but often competing. A discourse is not like a tribe. Particular individuals may partially inhabit competing discourses that make claims upon them.” ([Dryzek, 2013, p. 41](zotero://select/library/items/IERE36N2))
        
        - _We are currently in a discursive iterregnum with regard to the environment_

## Chapter 7: Greener Growth: Sustainable Development

## Chapter 8: Industrial Society and Beyond: Ecological Modernization